#!/bin/sh
if [ ! -f /etc/debian_version ]; then
    echo "Debian Jessie required. Stopping."
    exit 1
fi
dpkg --compare-versions $(cat /etc/debian_version) lt 8.0 || dpkg --compare-versions $(cat /etc/debian_version) ge 9.0
if [ $? -eq 0 ]; then
    echo "Debian Jessie required. Stopping."
    exit 1
fi

echo "net.ipv4.ip_nonlocal_bind=1" | tee -a /etc/sysctl.conf
echo "fs.file-max=3355444" | tee -a /etc/sysctl.conf
echo "vm.swappiness=1" | tee -a /etc/sysctl.conf
echo "KOHANA_ENV=production" | tee -a /etc/environment

apt-get update
apt-get install -y git supervisor
apt-get install -y php5-cli php5-mcrypt php5-mysql php5-pgsql php5-gearman

apt-get install -y libmysqlclient18 libodbc1 libpq5
wget http://sphinxsearch.com/files/sphinxsearch_2.2.11-release-1~jessie_amd64.deb
dpkg -i sphinxsearch_2.2.11-release-1~jessie_amd64.deb
rm sphinxsearch_2.2.11-release-1~jessie_amd64.deb
sed -i 's/START\s*=\s*yes/START=no/' /etc/default/sphinxsearch

cd /var/www
/usr/bin/php index.php --task=indexer:prepare
